/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.query.builder;

import javax.annotation.Nullable;
import org.codefilarete.stalactite.query.builder.DMLNameProvider;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.Selectable;

public interface SQLAppender {
    public SQLAppender cat(String var1, String ... var2);

    public <V> SQLAppender catValue(@Nullable Selectable<V> var1, Object var2);

    public SQLAppender catValue(Object var1);

    public SQLAppender catColumn(Selectable<?> var1);

    public SQLAppender catTable(Fromable var1);

    public SQLAppender removeLastChars(int var1);

    default public SQLAppender catIf(boolean condition, String s) {
        if (condition) {
            this.cat(s, new String[0]);
        }
        return this;
    }

    default public boolean isEmpty() {
        return this.getSQL().isEmpty();
    }

    public String getSQL();

    public SubSQLAppender newSubPart(DMLNameProvider var1);

    public static abstract class DefaultSubSQLAppender
    implements SubSQLAppender {
        private final SQLAppender delegate;

        public DefaultSubSQLAppender(SQLAppender delegate) {
            this.delegate = delegate;
        }

        public SQLAppender getDelegate() {
            return this.delegate;
        }

        @Override
        public SubSQLAppender cat(String s, String ... ss) {
            this.delegate.cat(s, ss);
            return this;
        }

        @Override
        public <V> SubSQLAppender catValue(@Nullable Selectable<V> column, Object value) {
            this.delegate.catValue(column, value);
            return this;
        }

        @Override
        public SubSQLAppender catValue(Object value) {
            this.delegate.catValue(value);
            return this;
        }

        @Override
        public SubSQLAppender catColumn(Selectable<?> column) {
            this.delegate.catColumn(column);
            return this;
        }

        @Override
        public SubSQLAppender catTable(Fromable table) {
            this.delegate.catTable(table);
            return this;
        }

        @Override
        public SubSQLAppender removeLastChars(int length) {
            this.delegate.removeLastChars(length);
            return this;
        }

        @Override
        public SubSQLAppender catIf(boolean condition, String s) {
            this.delegate.catIf(condition, s);
            return this;
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public String getSQL() {
            return this.delegate.getSQL();
        }

        @Override
        public SubSQLAppender newSubPart(DMLNameProvider dmlNameProvider) {
            return this.delegate.newSubPart(dmlNameProvider);
        }
    }

    public static interface SubSQLAppender
    extends SQLAppender {
        @Override
        public SubSQLAppender cat(String var1, String ... var2);

        @Override
        public <V> SubSQLAppender catValue(@Nullable Selectable<V> var1, Object var2);

        @Override
        public SubSQLAppender catValue(Object var1);

        @Override
        public SubSQLAppender catColumn(Selectable<?> var1);

        @Override
        public SubSQLAppender catTable(Fromable var1);

        @Override
        public SubSQLAppender removeLastChars(int var1);

        public SQLAppender close();
    }
}

